
// function for checking if a watering event has occurred
byte wateringEventCheck() {
  // compare moisture now to moisture one minute ago
  // if level has changed by +x amount, then watering has occurred
  //
  byte returnValue = 0;
  static unsigned long lastMeasure; // time we last measured the watering event moisture variable
  static int wateredValue = 1023; // initialize the watering event value with saturation, to prevent an initial false postitive
  int lastWateredValue = wateredValue; // update a variable with the last watering event moisture value taken
  if((millis() - lastMeasure) / 1000 > wateredTimeInterval) {
    blinkLED(ledPin, 2, 25); // led shows that project is still running
    wateredValue = analogRead(moistPin); // read the current watering event moisture value
    lastMeasure = millis(); 
    debug.print("W: ");
    debug.println(wateredValue,DEC);
    debug.print("L: ");
    debug.println(lastWateredValue,DEC);
    if (wateredValue > lastWateredValue + wateringCriteria) {
      if (lastWateredValue > minMoist[plantID]) {
        returnValue = 5; // you watered me when I didn't need it
      }
      else if (wateredValue < desiredSoakLevel[plantID]) {
        returnValue = 4; // I wasn't watered enough
      }
      else {
        returnValue = 3; // thanks for watering me
      }
    }
  }
  else {
    returnValue = 0; // otherwise no watering event was detected during this function call
  }
  return returnValue;
}


//function for checking soil moisture against threshold
//function for moving average with soil moisture--adapted from the light code
byte moistureCheck() {
  static byte returnValue = 0;
  static int counter = 1;//init static counter
  static unsigned long lastMeasure; // time we last measured the soil moisture variable
  int moistAverage = 0; // init soil moisture average
  if((millis() - lastMeasure) / 1000 > (moistTimeInterval / moistNumSamples)) {
    for(int i = moistArraySize - 1; i > 0; i--) {
      moistValues[i] = moistValues[i-1]; //move the first measurement to be the second one, and so forth until we reach the end of the array.   
    }
    moistValues[0] = analogRead(moistPin);//take a measurement and put it in the first place
    lastMeasure = millis();
    int moistTotal = 0;//create a little local int for an average of the moistValues array
    for(int i = 0; i < moistArraySize; i++) {//average the measurements (but not the nulls)
      moistTotal = moistTotal + moistValues[i];//in order to make the average we need to add them first 
    }
    if(counter<moistArraySize) {
      moistAverage = moistTotal/counter;
      counter++; //this will add to the counter each time we've gone through the function
    }
    else {
      moistAverage = moistTotal/moistArraySize;//here we are taking the total of the current light readings and finding the average by dividing by the array size
    } 
    //lastMeasure = millis();
    debug.print("m: ");
    debug.println(moistAverage,DEC); 

    ///return values
    if (moistAverage < maxDry[plantID]) {
      returnValue = 6;//we are in an urgent state of maximum dryness. please water this instant!
    } 
    else if (moistAverage <= minMoist[plantID]) {//
      returnValue = 2;//we are dry, make a phone call that requests to be watered
    }
    else {
      returnValue = 0;
    }
  }
  return returnValue;
}

/// 
/*

// function for checking light level WE NEED TO ADJUST THE 1 AND 0 SETTING FOR EACH PLANT BASED ON REAL LIGHT TESTING
byte lightCheck(int desiredAverage) {
  static byte returnValue = 9;
  static int counter = 1;//init static counter
  static unsigned long lastMeasure;//time we last measured the light variable
  // reset lastMeasure if clock register overflows http://www.arduino.cc/en/Reference/Millis
  if(lastMeasure > millis()) lastMeasure = millis();
  int lightAverage = 0;//init light average
  if((millis() - lastMeasure) / 1000 > (lightTimeInterval / lightNumSamples)) {
    for(int i = lightArraySize - 1; i > 0; i--) {
      lightValues[i] = lightValues[i-1]; //move the first measurement to be the second one, and so forth until we reach the end of the array.   
    }

    lightValues[0] = analogRead(lightPin);//take a measurement and put it in the first place
    lastMeasure = millis();
    int lightTotal = 0;//create a little local int for an average of the lightValues array
    for(int i = 0; i < lightArraySize; i++) {//average the measurements (but not the nulls)
      lightTotal = lightTotal + lightValues[i];//in order to make the average we need to add them first 
    }
    if(counter<lightArraySize) {
      lightAverage = lightTotal/counter;
      counter++; //this will add to the counter each time we've gone through the function
    }
    else {
      lightAverage = lightTotal/lightArraySize;//here we are taking the total of the current light readings and finding the average by dividing by the array size
    } 
    lastMeasure = millis();
    debug.print("l: ");
    debug.println(lightAverage,DEC); 

    if (lightAverage < desiredAverage) { // average minus padding is too low
      returnValue = 7;
    }
    else if (lightAverage > desiredAverage) { // average plus padding is too high
      returnValue = 9;
    }
  }
  return returnValue;
  //now we've created an average light read
}
*/
/// 
