
boolean deviceConnect(char* ipAddress, char* port) {
  digitalWrite(sleepPin,LOW);
  delay(14); // 14 ms delay allows XBee to wake up from sleep mode
  boolean success = false;
  byte ctr=0;
  while (success == false && ctr < 3) { // try to make a XPort connection upload 20 times
    Serial.flush();
    sendData("C", XPortAddr); // instructs the XPort that a Connect message is coming
    sendData(ipAddress, XPortAddr); // IP address of the server to connect to
    sendData("/", XPortAddr); // slash to indicate port number is coming
    sendData(port, XPortAddr);// TCP/IP port number to connect to
    sendData("\n", XPortAddr); // end of line to finish the request
    if (checkFor("C", 3000)) {
      // if a connect response was received from the XPort then continue
      debug.println("true"); 
      success = true;
    }
    else {
      debug.println("false");
      success = false; // otherwise go back and try setup again
    }
    ctr++;
  }
  return success;
}


void dataSend() {
  static unsigned long lastSend=0; // time we last measured the watering event moisture variable
  // jitter the interval by plant ID so that plants don't all try to connect at exactly the same time
  if((millis() - lastSend) / 1000 > dataInterval+plantID) { 
    if (deviceConnect("128.122.253.189","80") == true) {
      httpDataSend();
      lastSend = millis(); 
    }
  }
}



void httpDataSend() {
  digitalWrite(sleepPin,LOW);
  delay(14); // 14 ms delay allows XBee to wake up from sleep mode
  boolean success = false;
  byte ctr = 0;
  while (success == false && ctr < 6) { // try to make a database upload six times
    // Make HTTP GET request
    Serial.flush(); // clear the serial port for new incoming data
    Serial.print("GET /~kl892/bcalls.php?a=sensordata&id=");
    if (plantID < 100) Serial.print("0");
    if (plantID < 10) Serial.print("0");
    Serial.print(plantID, DEC);
    Serial.print("&t=M&v=");
    Serial.print(analogRead(moistPin), DEC);
    // Serial.print(" HTTP/1.1");
    Serial.print("\n");
    //Serial.print("HOST:itp.nyu.edu\n\n"); // server's hostname
    if (checkFor("SUCC",3000)) { // check for the "ok" response from the server
      debug.println("dbOK");
      success = true;
    } 
    else {
      debug.println("dbBad");
      success = false;
      // If we are in Monitor Mode (and we don't know why this happens) then attempt to quit out of it
      // Serial.flush(); // clear the serial port for incoming data
      // Serial.print("\n"); // send some line feeds
      // if (checkFor("9>", 500)) { // see if we get back an error prompt from Monitor Mode
      // Serial.print("QU\n");  // if we sense Monitor Mode then send the quit command
      // debug.println("TryQuit"); 
      // }
    }
    ctr++;
  }
  delay(5000); // wait for XBee's RSSI light to go out, otherwises it stays on and uses power continuously
  digitalWrite(sleepPin,HIGH);
}


// +++++++++++++
// Send an HTTP GET request
boolean httpRequest(char* ipAddress, char* port, int messageType) {
  boolean success = false;
  digitalWrite(sleepPin,LOW);
  delay(14); // 14 ms delay allows XBee to wake up from sleep mode

  connectIPGate();

  if (deviceConnect(ipAddress, port) == true) {
    // char phone [] = "12129896888"; // Hartman: 19178417494, London: 19174342135, Faludi 12129896888, Lounge: 12129981877
    // LearningWorlds: 16464424409
    Serial.flush(); // clear serial before the next request
    sendData("GET /~kh928/bcall.php?id=", XPortAddr);
    if (plantID < 100) sendData("0", XPortAddr);
    if (plantID < 10) sendData("0", XPortAddr);
    char plantString[3];
    itoa(plantID, plantString, 10);
    sendData(plantString, XPortAddr);
    sendData("&c=", XPortAddr);
    char messageString[2];
    itoa(messageType, messageString, 10);
    sendData(messageString, XPortAddr);
    sendData("&s=", XPortAddr);
    char siteString[2];
    itoa(site, siteString, 10);
    sendData(siteString, XPortAddr);

    sendData("\n", XPortAddr);
    //    sendData("HOST:asterisk.itp.tsoa.nyu.edu\n\n", XPortAddr); // server's hostname
    if (checkFor("BAM!",3000)) { // check for the "ok" message in the server's response
      debug.println("CallOK");
      success = true;
      Serial.flush(); // clear the serial port of extraneous packets
    }
    else {
      debug.println("CallBad");
      success = false;
      quitMonitorMode();
    }
  }
  else {
    debug.println("ConBad");
    success = false;
    quitMonitorMode();
  }
  setupXBee();
  delay(5000); // wait for XBee's RSSI light to go out, otherwises it stays on and uses power continuously
  digitalWrite(sleepPin,HIGH);
  return success;
}


void quitMonitorMode() {
  // If we are in Monitor Mode then attempt to quit out of it
  Serial.flush(); //++++++++++++++++
  sendData("\n", XPortAddr); // send a line feed
  if (checkFor("9>", 500)) { // see if we get back an error prompt from Monitor Mode
    sendData("RS\n", XPortAddr);  // if we sense Monitor Mode then send the quit command
    debug.println("TryRset"); 
  }
}

void connectIPGate() {
  boolean outcome = false;
  while (outcome == false) {
    outcome = sendCommand("ID", 0x7777);
  }
  outcome = false;
  while (outcome == false) {
    outcome = sendCommand("MY", 0x63);
  }
}



void setupXBee() {
  // send commands using the sendCommand() function
  boolean outcome = false;
  while (outcome == false) {
    outcome = sendCommand("ID", 0x7777);
  }
  outcome = false;
  while (outcome == false) {
    outcome = sendCommand("MY", plantID);
  }
  outcome = false;
  while (outcome == false) {
    outcome = sendCommand("DH", 0x0);
  }
  outcome = false;
  while (outcome == false) {
    outcome = sendCommand("DL", 0x64);
  }
  outcome = false;
  while (outcome == false) {
    outcome = sendCommand("SM", 0x1);
  }
}
