// Twitter Code by Limor http://www.ladyada.net

/***********************SOFTWARE UART*************************/

uint8_t serialavail_timeout(int timeout) {  // in ms
 
  while (timeout) {
    if (mySerial.available()) {
      if (XPORT_CTSPIN) { // we read some stuff, time to stop!
        digitalWrite(XPORT_CTSPIN, HIGH);
      }
      return 1;
    }
    // nothing in the queue, tell it to send something
    if (XPORT_CTSPIN) {
     digitalWrite(XPORT_CTSPIN, LOW);
    }
    timeout -= 1;
    delay(1);
  }
  if (XPORT_CTSPIN) { // we may need to process some stuff, so stop now
     digitalWrite(XPORT_CTSPIN, HIGH);
  }
  return 0;
}

uint8_t readline_timeout(int timeout) {
  uint8_t idx=0;
  char c;
  while (serialavail_timeout(timeout)) {
      c = mySerial.read();
      linebuffer[idx++] = c;
      if ((c == '\n') || (idx == 255)) {
        linebuffer[idx] = 0;
        errno = ERROR_NONE;
        return idx;
      }
  }
  linebuffer[idx] = 0;
  errno = ERROR_TIMEDOUT;
  return idx;
}

/********************XPORT STUFF**********************/

uint8_t XPort_reset(void) {
  char d;
  
  // 200 ms reset pulse
  digitalWrite(XPORT_RESETPIN, LOW);
  delay(200);
  digitalWrite(XPORT_RESETPIN, HIGH);
  
  // wait for 'D' for disconnected
  if (serialavail_timeout(5000)) { // 3 second timeout 
    d = mySerial.read();
    //Serial.print("Read: "); Serial.print(d, HEX);
    if (d != 'D'){
      return ERROR_BADRESP;
    } else {
      return 0;
    }
  }
  return ERROR_TIMEDOUT;
}  

uint8_t XPort_disconnected(void) {
  if (XPORT_DTRPIN != 0) {
     return digitalRead(XPORT_DTRPIN);
  } 
  return 0;
}


uint8_t XPort_connect(char *ipaddr, long port) {
  char ret;
  
  mySerial.print('C');
  mySerial.print(ipaddr);
  mySerial.print('/');
  mySerial.println(port);
  // wait for 'C'
  if (serialavail_timeout(3000)) { // 3 second timeout 
    ret = mySerial.read();
    Serial.print("Read: "); Serial.print(ret, HEX);
    if (ret != 'C') {
      return ERROR_BADRESP;
    }
  } else { 
    return ERROR_TIMEDOUT; 
  }
  return 0;
}

void XPort_flush(int timeout) {
  while (serialavail_timeout(timeout)) {
      mySerial.read();
  }
}

/********************TWITTER STUFF**********************/

uint8_t posttweet(char *tweet) {
  uint8_t ret;
  uint8_t success = 0;

  ret = XPort_reset();
  //Serial.print("Ret: "); Serial.print(ret, HEX);
  switch (ret) {
   case  ERROR_TIMEDOUT: { 
      Serial.println("Timed out on reset!"); 
      return 0;
   }
   case ERROR_BADRESP:  { 
      Serial.println("Bad response on reset!");
      return 0;
   }
   case ERROR_NONE: { 
    Serial.println("Reset OK!");
    break;
   }
   default:
     Serial.println("Unknown error"); 
     return 0;
  }
  
  // time to connect...
 
  ret = XPort_connect(IPADDR, PORT);
    switch (ret) {
   case  ERROR_TIMEDOUT: { 
      Serial.println("Timed out on connect"); 
      return 0;
   }
   case ERROR_BADRESP:  { 
      Serial.println("Failed to connect");
      return 0;
   }
   case ERROR_NONE: { 
     Serial.println("Connected..."); break;
   }
   default:
     Serial.println("Unknown error"); 
     return 0;
  }

  base64encode(USERNAMEPASS, linebuffer);
  
  // send the HTTP command, ie "GET /username/"
  mySerial.print("POST "); mySerial.print(HTTPPATH); mySerial.println(" HTTP/1.1");
  Serial.print("POST "); Serial.print(HTTPPATH); Serial.println(" HTTP/1.1");
  // next, the authentication
  mySerial.print("Host: "); mySerial.println(IPADDR);
  Serial.print("Host: "); Serial.println(IPADDR);
  mySerial.print("Authorization: Basic ");
  Serial.print("Authorization: Basic ");
  mySerial.println(linebuffer);
  Serial.println(linebuffer);
  mySerial.print("Content-Length: "); mySerial.println(7+strlen(tweet), DEC);
  Serial.print("Content-Length: "); Serial.println(7+strlen(tweet), DEC);
  mySerial.print("\nstatus="); mySerial.println(tweet);
  Serial.print("\nstatus="); Serial.println(tweet);
  
  mySerial.println("");  
 
  while (1) {
    // read one line from the xport at a time
    ret = readline_timeout(3000); // 3s timeout
    // if we're using flow control, we can actually dump the line at the same time!
    Serial.print(linebuffer);
    if (strstr(linebuffer, "HTTP/1.1 200 OK") == linebuffer)
       success = 1;
    
    if (((errno == ERROR_TIMEDOUT) && XPort_disconnected()) ||
        ((XPORT_DTRPIN == 0) &&
         (linebuffer[0] == 'D') && (linebuffer[1] == 0)))  {
       Serial.println("\nDisconnected...");
       return success;
    }
  }
}


void base64encode(char *s, char *r) {
  char padstr[4];
  char base64chars[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
  uint8_t i, c;
  uint32_t n;
  
  c = strlen(s) % 3;
  if (c > 0) { 
    for (i=0; c < 3; c++) { 
      padstr[i++] = '='; 
    } 
  }
  padstr[i]=0;

  i = 0;
  for (c=0; c < strlen(s); c+=3) { 
     // these three 8-bit (ASCII) characters become one 24-bit number
     n = s[c]; n <<= 8;
     n += s[c+1]; 
     if (c+2 > strlen(s)) {
       n &= 0xff00;
     }
     n <<= 8;
     n += s[c+2];
     if (c+1 > strlen(s)) {
       n &= 0xffff00;
     }
       
     // this 24-bit number gets separated into four 6-bit numbers
     // those four 6-bit numbers are used as indices into the base64 character list
     r[i++] = base64chars[(n >> 18) & 63];
     r[i++] = base64chars[(n >> 12) & 63];
     r[i++] = base64chars[(n >> 6) & 63];
     r[i++] = base64chars[n & 63];
  }
  i -= strlen(padstr);
  for (c=0; c<strlen(padstr); c++) {
    r[i++] = padstr[c];  
  }
  r[i] = 0;
  Serial.println(r);
}

