boolean checkSunny() {
  // this function checks with neighboring plants to see if they are satisfied with their light levels
  // if neighbors are satisfied, but you are not, then it's appropriate to make a complaint call
  int Y=0,N=0; // yes and no response counters for satisfaction with light levels
  int timeout = 500; // timeout for checking each neighbor
  boolean result = true; // assume that it's sunny to begin with

  // ask each neighbor if they are satisfied with their light levels
  for (int i=0; i < 16; i++) {
    digitalWrite(sleepPin, LOW);
    delay(14);
    sendData("L", i); // send out an Light level data request
    char* incomingResponse;
    incomingResponse = getData(incomingResponse, timeout); 
    if (incomingResponse != NULL) { // if we didn't read a bad packet
      if (strstr(incomingResponse,"Y") != NULL ) { // if the desired string is found
        Y++;
      }
      else if (strstr(incomingResponse,"N") != NULL ) { // if the desired string is found
        N++;
      }
      else { 
        debug.println("bad response");
      }
    }
    else { 
      debug.println("bad packet");
    }
    free(incomingResponse); // free the string's allocated memory for reuse
  } 

  // evaluate responses
  if (Y >= N) {
    result = true; // if more happy than not, or no responses, assume that it's sunny
  }
  else {
    result = false; // otherwise it seems to be cloudy
  }
  delay(5000); // wait for XBee's RSSI light to go out, otherwises it stays on and uses power continuously
  digitalWrite(sleepPin,HIGH);
  return result;
}


void respondToRequests() {
  if (Serial.available() > 0) {
    char* incomingResponse;
    incomingResponse = getData(incomingResponse, 1000);
    if (incomingResponse != NULL) { // if we didn't read a bad packet
      if (strstr(incomingResponse,"L") != NULL ) { // if this is a light level request
        debug.print("Lyes"); // indicate this was a light request
         byte light = lightCheck(lightMinimum); // returns a value dependent upon light level
        if (light == 9) { // if we're happy with our light level
          sendData("Y", lastSender);
        }
        else if (light == 7) {
          sendData("N", lastSender);
        }
      }
      else { 
        debug.print("Lno");  // indicate this wasn't a light request
      }
    }
    free(incomingResponse); // free the string's allocated memory for reuse
  }
} 
