void timeCheck() {
  Serial.flush(); // clear the serial buffer before reading new data
  char timeString[15]; // create a string to hold the time value when it's read
  memset(timeString,'\0',15); // initialize that string to all NULL characters
  byte inByte = '\0'; // declare and initialize a byte to read in serial data
  while(inByte != '*') {
    inByte = Serial.read(); // read data and wait for an asterisk character
  }
  boolean timeStringValid = true; // declare and initialize a variable to track whether the string has all valid characters
  while(Serial.available() < 14) {
    ; //wait for enough data to be available (14 characters of time string), while doing nothing else
  }
  for (int i=0; i < 14; i++) {
    timeString[i] = Serial.read(); // reach each time string character into a character array
    if(timeString[i] < '0' || timeString[i] > '9') {
      timeStringValid = false;  // if any character is bad then the whole string is bad
    }
  }

  if (timeStringValid == true) {
    char yearString[5];  // create a string to hold the year part of the string
    memset(yearString,'\0',5); // initialize that string to all NULL characters
    strncpy( yearString, timeString, 4); // copy the first four characters of timeString into the year string
    time.year = atoi(yearString); // convert ASCII year string to integer and store in the year integer variable

    char monthString[3]; // create a string to hold the month part of the string
    memset(monthString,'\0',3); // initialize that string to all NULL characters
    strncpy( monthString, timeString+4, 2); // skip four characters, then copy the next two of timeString into the month string
    time.month = atoi(monthString);  // convert ASCII month string to integer and store in the month integer variable

    char dayString[3];
    memset(dayString,'\0',3);
    strncpy( dayString, timeString+6, 2);
    time.day = atoi(dayString);

    char hourString[3];
    memset(hourString,'\0',3);
    strncpy( hourString, timeString+8, 2);
    time.hour = atoi(hourString);

    char minuteString[3];
    memset(minuteString,'\0',3);
    strncpy( minuteString, timeString+10, 2);
    time.minute = atoi(minuteString);

    char secondString[3];
    memset(secondString,'\0',3);
    strncpy( secondString, timeString+12, 2);
    time.second = atoi(secondString);
  }
}
