#include "WProgram.h"
byte wateringEventCheck();
byte moistureCheck();
byte lightCheck(int desiredAverage);
boolean deviceConnect(char* ipAddress, char* port);
void dataSend();
boolean httpRequest(char* ipAddress, char* port, int messageType);
void quitMonitorMode();
void connectIPGate();
void setupXBee();
boolean checkSunny();
void respondToRequests();
int checkMetronome(int timeout);
int getHour(int timeout);
boolean checkFor(char* desiredResponse, int timeout);
int memoryTest();
void blinkLED(byte targetPin, int numBlinks, int blinkRate);
boolean sendCommand(char* command, unsigned long data);
boolean getCommandResults();
int checkHeader(int timeout);
boolean getIdentifier(byte idWanted);
boolean getTXstatus();
boolean sendData(char* data, int destinationAddr);
void setAPIMode();
int countBytes(long myLong);
#include "SoftwareSerial.h"
// This program helps a plant to make a phone call.
// Rob Faludi with additional code from various public examples
// http://www.botanicalls.com
// A project with Kati London, Rob Faludi, Kate Hartman and Rebecca Bray

char version[] = "1.84";

boolean demoMode = false; // set this to true for short timeouts and no data uploads
boolean sociable = false; // set this to true to use the Sociable Objects code
byte XPortAddr = 0x64;
int site = 2; // indicator for where the plant is located
// 1 is demo, 2 is ITP lounge, 3 is Machine Project, 4 is development

// char* functions need to be declared at the start of C programs
char* getData(char* dataIn, int timeout);

byte plantID; // unique plant identifier
// time intervals for regular use
// THESE WILL BE MODIFIED IN THE SETUP FUNCTION IF DEMO MODE IS ON
int wateredTimeInterval = 30; // watering event interval in seconds
unsigned int lightTimeInterval = 18*60*60;//light intervals in seconds (for hours use h*60*60)
unsigned int moistTimeInterval = 18*60*60;//moisture interval in seconds
int dataInterval = 1800; // data sending for SQL, interval in seconds


// the positive increase in moisture that defines a watering event
int wateringCriteria = 100;

int lightNumSamples = 10; //number of sampled light values at the determined intervals
int moistNumSamples = 10; //number of sampled moisture values at the determined intervals
//most desirable state of wetness during a watering event--PLANT SPECIFIC VALUE
int desiredSoakLevel[14] = {
  600, 455, 280, 660, 700, 700, 700, 720, 700, 460, 690, 600, 550, 700};
//sufficiently dried out to be watered---PLANT SPECIFIC VALUE
int minMoist[14] = {
  450, 350, 1, 550, 400, 590, 500, 610, 500, 300, 560, 560, 330, 550};
//Unhealthfully dried out, desperately needs water---PLANT SPECIFIC VALUE
int maxDry[14] = {
  400, 280, 0, 490, 320, 500, 400, 510, 400, 200, 490, 490, 200, 490}; 
int lightMinimum = 96;// generally desired light level. Plant specific light threshholds TBD

//set up the moist array of n values---replace 10 w/96
int moistValues[10];

int moistArraySize = moistNumSamples; //size of the soil moisture array

int lightArraySize = lightNumSamples; // size of the light array 
int lightValues[10]; // set up the light array of n values--replace 10 w/96


// pins for PCB layout
byte ledPin = 13; // generic status LED
byte moistLED = 9;  // LED which indicates the plant needs water
byte sleepPin = 4; // bring this pin HIGH to make the XBee sleep and LOW to wake it up (connects to pin 9 on XBee)
byte ID1 = 5, ID2 = 6, ID3 = 7, ID4 = 8;
byte moistPin = 0; // moisture input is on analog pin 0
byte lightPin = 1; //photocell input is on analog port 1
byte batteryPin = 12; // monitor battery level. active is high


// limits the maximum number and frequency of calls
int callSpacing = 20; // minimum seconds between each call
long lastCallTime = 0; // holds the last time we made a call
int callLimit = 30000; // maximum number of attempted http connects to call
int calls = 0;  // holds the current number of attempted http connects 
int lastWatered = 255; // this holds the last value of watering event check, set high to ensure descent
int lastMoist = 255;//this holds the last value of the moisture check, set high to ensure descent
int lastLight = 255;//this holds the last value of the light check, set high to ensure descent

// sociable objects section
boolean neglected = false; // true if others had light when you didn't
int lastSender = 0; // global variable for the address of the most recent XBee sender


////// DEBUG OUTPUT IS HANDY ///////
int debugRX=2, debugTX=3; // pins 2 and 3 are for debug output
SoftwareSerial debug(debugRX, debugTX); // creates SoftwareSerial on pins 6 and 7
///////////////////////////////////////////////////////////////


void setup () {
  //// for(int i = 0; i < lightArraySize; i++) {
  ////    lightValues[i] = 1023; 
  ////  }
  plantID = (digitalRead(ID1)) + (digitalRead(ID2) << 1)  + (digitalRead(ID3) << 2)  + (digitalRead(ID4) << 3); 
  for(int i = 0; i < moistArraySize; i++) {
    moistValues[i] = 0; 
  }
  // start up the serial connection with 9600-8-n-1-true (non-inverted):
  Serial.begin(9600);
  debug.begin(9600); // start software serial process
  pinMode(ledPin,OUTPUT);
  pinMode(moistLED,OUTPUT);  
  pinMode(sleepPin,OUTPUT);
  pinMode(ID1,INPUT);
  pinMode(ID2,INPUT);
  pinMode(ID3,INPUT);
  pinMode(ID4,INPUT);
  pinMode(debugRX,INPUT);
  pinMode(debugTX,OUTPUT);
  pinMode(batteryPin,INPUT);
  /////debugging serial output///////
  debug.print("start v");
  debug.print(version);
  debug.print(" ID ");
  debug.println(plantID,DEC);


  // time intervals for demo mode
  if (demoMode == true) {
    wateredTimeInterval = 5; // watering event interval in seconds
    lightTimeInterval = 5;//light intervals in seconds
    moistTimeInterval = 5;//moisture interval in seconds
    dataInterval = 36000; // data sending for SQL, interval in seconds
    int callSpacing = 5; // minimum seconds between each call
    debug.println("Demo");
  }
  lastCallTime = 5000 - ((callSpacing + 1) * 1000); // special calculation to immediately enable calls

  //////////////////////////////////
  digitalWrite(sleepPin, LOW);
  delay(14); // 14 ms delay allows XBee to wake up from sleep mode
  setAPIMode(); // puts the XBee into API packetized mode
  setupXBee(); // initialize the proper settings on the XBee radio module
  digitalWrite(sleepPin, HIGH);
  debug.print(memoryTest());
  debug.println("b free");
}


void loop () {
  if (demoMode == false) {
    // dataSend(); // send moisture data to mySQL database
  }

  byte watered = wateringEventCheck(); // returns a value dependent upon watering events
  byte moist = moistureCheck(); // returns a value dependent upon moisture level
  byte light = lightCheck(lightMinimum); // returns a value dependent upon light level
  if (millis() - lastCallTime > (callSpacing+1) * 1000 && calls < callLimit) {
    //if we're not too close to the last call and we haven't made too many calls...j
    if (watered > lastWatered) { //if there's been a positive change
      byte ctr = 0;
      debug.println("WCall");
      // place a call request, using the value returned by watering event check
      while (httpRequest("128.122.151.44","80",watered) == false && ctr < 3) {
        ctr++;
      }
      lastWatered = watered;//log the current moisture value so you can compare it to the next value that comes in

      calls++;//add one to the count of the number of phone call attempts made
      lastCallTime = millis();
    }


    else if (moist > lastMoist) { //if there's been a positive change
      byte ctr = 0;
      debug.println("MCall");
      while (httpRequest("128.122.151.44","80",moist) == false && ctr < 3) {
        ctr++;
      }
      lastMoist = moist;//log the current moisture value so you can compare it to the next value that comes in
      calls++;//add one to the count of the number of phone calls made
      lastCallTime = millis();
    }


    else  if (light != lastLight){//if there has been a change
      byte ctr = 0;
      debug.println("LCall");

      if (sociable == true && light < lastLight) { // if the sociable objects mode is enabled and light is lacking
 /*
        neglected = checkSunny();    
        if (neglected == true) {
          int hour = getHour(2000);
          if (hour == NULL || (hour > 8 && hour < 23)) { // if daytime or no response, okay to make call
            int idleTime = checkMetronome(2000);
            if (idleTime == NULL || (idleTime > 1800)) {
              while (httpRequest("128.122.151.44","80",light) == false && ctr < 3) {
                ctr++; 
              }
            }
          }
        }
      */
      }
      else if (sociable == false || neglected == true) { // if the sociable objects mode is disabled or if complaint was made
        while (httpRequest("128.122.151.44","80",light) == false && ctr < 3) {
          ctr++;
        }
      }
      lastLight = light;
      calls++;//add one to the count of the number of phone calls made
      lastCallTime = millis();
    }

  }


  lastWatered = watered;//log the current watering value so you can compare it to the next value that comes in
  lastMoist = moist;//log the current moisture value so you can compare it to the next value that comes in
  lastLight = light;//log the light value so you can compare it to the next value that comes in


  switch (moist) {
  case 2: // min moist
    blinkLED(moistLED, 1, 200);
    break;
  case 6: // max dry
    blinkLED(moistLED, 1, 50);
    break;
  default:
    int brightness = analogRead(moistPin);
    analogWrite(moistLED,brightness); // otherwise display a steady LED with brightness mapped to moisture
    break;
  }
/*
  if (sociable == true) { // if the sociable objects mode is enabled
    digitalWrite(sleepPin, LOW);
    respondToRequests();
  }
  */
}





// function for checking if a watering event has occurred
byte wateringEventCheck() {
  // compare moisture now to moisture one minute ago
  // if level has changed by +x amount, then watering has occurred
  //
  byte returnValue = 0;
  static unsigned long lastMeasure; // time we last measured the watering event moisture variable
  static int wateredValue = 1023; // initialize the watering event value with saturation, to prevent an initial false postitive
  int lastWateredValue = wateredValue; // update a variable with the last watering event moisture value taken
  if((millis() - lastMeasure) / 1000 > wateredTimeInterval) {
    blinkLED(ledPin, 2, 25); // led shows that project is still running
    wateredValue = analogRead(moistPin); // read the current watering event moisture value
    lastMeasure = millis(); 
    debug.print("W: ");
    debug.println(wateredValue,DEC);
    debug.print("L: ");
    debug.println(lastWateredValue,DEC);
    if (wateredValue > lastWateredValue + wateringCriteria) {
      if (lastWateredValue > minMoist[plantID]) {
        returnValue = 5; // you watered me when I didn't need it
      }
      else if (wateredValue < desiredSoakLevel[plantID]) {
        returnValue = 4; // I wasn't watered enough
      }
      else {
        returnValue = 3; // thanks for watering me
      }
    }
  }
  else {
    returnValue = 0; // otherwise no watering event was detected during this function call
  }
  return returnValue;
}


//function for checking soil moisture against threshold
//function for moving average with soil moisture--adapted from the light code
byte moistureCheck() {
  static byte returnValue = 0;
  static int counter = 1;//init static counter
  static unsigned long lastMeasure; // time we last measured the soil moisture variable
  int moistAverage = 0; // init soil moisture average
  if((millis() - lastMeasure) / 1000 > (moistTimeInterval / moistNumSamples)) {
    for(int i = moistArraySize - 1; i > 0; i--) {
      moistValues[i] = moistValues[i-1]; //move the first measurement to be the second one, and so forth until we reach the end of the array.   
    }
    moistValues[0] = analogRead(moistPin);//take a measurement and put it in the first place
    lastMeasure = millis();
    int moistTotal = 0;//create a little local int for an average of the moistValues array
    for(int i = 0; i < moistArraySize; i++) {//average the measurements (but not the nulls)
      moistTotal = moistTotal + moistValues[i];//in order to make the average we need to add them first 
    }
    if(counter<moistArraySize) {
      moistAverage = moistTotal/counter;
      counter++; //this will add to the counter each time we've gone through the function
    }
    else {
      moistAverage = moistTotal/moistArraySize;//here we are taking the total of the current light readings and finding the average by dividing by the array size
    } 
    //lastMeasure = millis();
    debug.print("m: ");
    debug.println(moistAverage,DEC); 

    ///return values
    if (moistAverage < maxDry[plantID]) {
      returnValue = 6;//we are in an urgent state of maximum dryness. please water this instant!
    } 
    else if (moistAverage <= minMoist[plantID]) {//
      returnValue = 2;//we are dry, make a phone call that requests to be watered
    }
    else {
      returnValue = 0;
    }
  }
  return returnValue;
}


// function for checking light level WE NEED TO ADJUST THE 1 AND 0 SETTING FOR EACH PLANT BASED ON REAL LIGHT TESTING
byte lightCheck(int desiredAverage) {
  static byte returnValue = 9;
  static int counter = 1;//init static counter
  static unsigned long lastMeasure;//time we last measured the light variable
  // reset lastMeasure if clock register overflows http://www.arduino.cc/en/Reference/Millis
  if(lastMeasure > millis()) lastMeasure = millis();
  int lightAverage = 0;//init light average
  if((millis() - lastMeasure) / 1000 > (lightTimeInterval / lightNumSamples)) {
    for(int i = lightArraySize - 1; i > 0; i--) {
      lightValues[i] = lightValues[i-1]; //move the first measurement to be the second one, and so forth until we reach the end of the array.   
    }

    lightValues[0] = analogRead(lightPin);//take a measurement and put it in the first place
    lastMeasure = millis();
    int lightTotal = 0;//create a little local int for an average of the lightValues array
    for(int i = 0; i < lightArraySize; i++) {//average the measurements (but not the nulls)
      lightTotal = lightTotal + lightValues[i];//in order to make the average we need to add them first 
    }
    if(counter<lightArraySize) {
      lightAverage = lightTotal/counter;
      counter++; //this will add to the counter each time we've gone through the function
    }
    else {
      lightAverage = lightTotal/lightArraySize;//here we are taking the total of the current light readings and finding the average by dividing by the array size
    } 
    lastMeasure = millis();
    debug.print("l: ");
    debug.println(lightAverage,DEC); 

    if (lightAverage < desiredAverage) { // average minus padding is too low
      returnValue = 7;
    }
    else if (lightAverage > desiredAverage) { // average plus padding is too high
      returnValue = 9;
    }
  }
  return returnValue;
  //now we've created an average light read
}



boolean deviceConnect(char* ipAddress, char* port) {
  digitalWrite(sleepPin,LOW);
  delay(14); // 14 ms delay allows XBee to wake up from sleep mode
  boolean success = false;
  byte ctr=0;
  while (success == false && ctr < 3) { // try to make a XPort connection upload 20 times
    Serial.flush();
    sendData("C", XPortAddr); // instructs the XPort that a Connect message is coming
    sendData(ipAddress, XPortAddr); // IP address of the server to connect to
    sendData("/", XPortAddr); // slash to indicate port number is coming
    sendData(port, XPortAddr);// TCP/IP port number to connect to
    sendData("\n", XPortAddr); // end of line to finish the request
    if (checkFor("C", 3000)) {
      // if a connect response was received from the XPort then continue
      debug.println("true"); 
      success = true;
    }
    else {
      debug.println("false");
      success = false; // otherwise go back and try setup again
    }
    ctr++;
  }
  return success;
}

/*
void dataSend() {
 static unsigned long lastSend=0; // time we last measured the watering event moisture variable
 // jitter the interval by plant ID so that plants don't all try to connect at exactly the same time
 if((millis() - lastSend) / 1000 > dataInterval+plantID) { 
 if (deviceConnect("128.122.253.189","80") == true) {
 httpDataSend();
 lastSend = millis(); 
 }
 }
 }
 
 
 
 void httpDataSend() {
 digitalWrite(sleepPin,LOW);
 delay(14); // 14 ms delay allows XBee to wake up from sleep mode
 boolean success = false;
 byte ctr = 0;
 while (success == false && ctr < 6) { // try to make a database upload six times
 // Make HTTP GET request
 Serial.flush(); // clear the serial port for new incoming data
 Serial.print("GET /~kl892/bcalls.php?a=sensordata&id=");
 if (plantID < 100) Serial.print("0");
 if (plantID < 10) Serial.print("0");
 Serial.print(plantID, DEC);
 Serial.print("&t=M&v=");
 Serial.print(analogRead(moistPin), DEC);
 // Serial.print(" HTTP/1.1");
 Serial.print("\n");
 //Serial.print("HOST:itp.nyu.edu\n\n"); // server's hostname
 if (checkFor("SUCC",3000)) { // check for the "ok" response from the server
 debug.println("dbOK");
 success = true;
 } 
 else {
 debug.println("dbBad");
 success = false;
 // If we are in Monitor Mode (and we don't know why this happens) then attempt to quit out of it
 // Serial.flush(); // clear the serial port for incoming data
 // Serial.print("\n"); // send some line feeds
 // if (checkFor("9>", 500)) { // see if we get back an error prompt from Monitor Mode
 // Serial.print("QU\n");  // if we sense Monitor Mode then send the quit command
 // debug.println("TryQuit"); 
 // }
 }
 ctr++;
 }
 delay(5000); // wait for XBee's RSSI light to go out, otherwises it stays on and uses power continuously
 digitalWrite(sleepPin,HIGH);
 }
 */

// +++++++++++++
// Send an HTTP GET request
boolean httpRequest(char* ipAddress, char* port, int messageType) {
  boolean success = false;
  digitalWrite(sleepPin,LOW);
  delay(14); // 14 ms delay allows XBee to wake up from sleep mode

  connectIPGate();

  if (deviceConnect(ipAddress, port) == true) {
    // char phone [] = "12129896888"; // Hartman: 19178417494, London: 19174342135, Faludi 12129896888, Lounge: 12129981877
    // LearningWorlds: 16464424409
    Serial.flush(); // clear serial before the next request
    sendData("GET /~kh928/bcall.php?id=", XPortAddr);
    if (plantID < 100) sendData("0", XPortAddr);
    if (plantID < 10) sendData("0", XPortAddr);
    char plantString[3];
    itoa(plantID, plantString, 10);
    sendData(plantString, XPortAddr);
    sendData("&c=", XPortAddr);
    char messageString[2];
    itoa(messageType, messageString, 10);
    sendData(messageString, XPortAddr);
    sendData("&s=", XPortAddr);
    char siteString[2];
    itoa(site, siteString, 10);
    sendData(siteString, XPortAddr);

    sendData("\n", XPortAddr);
    //    sendData("HOST:asterisk.itp.tsoa.nyu.edu\n\n", XPortAddr); // server's hostname
    if (checkFor("BAM!",3000)) { // check for the "ok" message in the server's response
      debug.println("CallOK");
      success = true;
      Serial.flush(); // clear the serial port of extraneous packets
    }
    else {
      debug.println("CallBad");
      success = false;
      quitMonitorMode();
    }
  }
  else {
    debug.println("ConBad");
    success = false;
    quitMonitorMode();
  }
  setupXBee();
  delay(5000); // wait for XBee's RSSI light to go out, otherwises it stays on and uses power continuously
  digitalWrite(sleepPin,HIGH);
  return success;
}


void quitMonitorMode() {
  // If we are in Monitor Mode then attempt to quit out of it
  Serial.flush(); //++++++++++++++++
  sendData("\n", XPortAddr); // send a line feed
  if (checkFor("9>", 500)) { // see if we get back an error prompt from Monitor Mode
    sendData("RS\n", XPortAddr);  // if we sense Monitor Mode then send the quit command
    debug.println("TryRset"); 
  }
}

void connectIPGate() {
  boolean outcome = false;
  while (outcome == false) {
    outcome = sendCommand("ID", 0x7777);
  }
  outcome = false;
  while (outcome == false) {
    outcome = sendCommand("MY", 0x63);
  }
}



void setupXBee() {
  // send commands using the sendCommand() function
  boolean outcome = false;
  while (outcome == false) {
    outcome = sendCommand("ID", 0x7777);
  }
  outcome = false;
  while (outcome == false) {
    outcome = sendCommand("MY", plantID);
  }
  outcome = false;
  while (outcome == false) {
    outcome = sendCommand("DH", 0x0);
  }
  outcome = false;
  while (outcome == false) {
    outcome = sendCommand("DL", 0x64);
  }
  outcome = false;
  while (outcome == false) {
    outcome = sendCommand("SM", 0x1);
  }
}

/*
boolean checkSunny() {
  // this function checks with neighboring plants to see if they are satisfied with their light levels
  // if neighbors are satisfied, but you are not, then it's appropriate to make a complaint call
  int Y=0,N=0; // yes and no response counters for satisfaction with light levels
  int timeout = 500; // timeout for checking each neighbor
  boolean result = true; // assume that it's sunny to begin with

  // ask each neighbor if they are satisfied with their light levels
  for (int i=0; i < 16; i++) {
    digitalWrite(sleepPin, LOW);
    delay(14);
    sendData("L", i); // send out an Light level data request
    char* incomingResponse;
    incomingResponse = getData(incomingResponse, timeout); 
    if (incomingResponse != NULL) { // if we didn't read a bad packet
      if (strstr(incomingResponse,"Y") != NULL ) { // if the desired string is found
        Y++;
      }
      else if (strstr(incomingResponse,"N") != NULL ) { // if the desired string is found
        N++;
      }
      else { 
        debug.println("bad response");
      }
    }
    else { 
      debug.println("bad packet");
    }
    free(incomingResponse); // free the string's allocated memory for reuse
  } 

  // evaluate responses
  if (Y >= N) {
    result = true; // if more happy than not, or no responses, assume that it's sunny
  }
  else {
    result = false; // otherwise it seems to be cloudy
  }
  delay(5000); // wait for XBee's RSSI light to go out, otherwises it stays on and uses power continuously
  digitalWrite(sleepPin,HIGH);
  return result;
}


void respondToRequests() {
  if (Serial.available() > 0) {
    char* incomingResponse;
    incomingResponse = getData(incomingResponse, 1000);
    if (incomingResponse != NULL) { // if we didn't read a bad packet
      if (strstr(incomingResponse,"L") != NULL ) { // if this is a light level request
        debug.print("Lyes"); // indicate this was a light request
        byte light = lightCheck(lightMinimum); // returns a value dependent upon light level
        if (light == 9) { // if we're happy with our light level
          sendData("Y", lastSender);
        }
        else if (light == 7) {
          sendData("N", lastSender);
        }
      }
      else { 
        debug.print("Lno");  // indicate this wasn't a light request
      }
    }
    free(incomingResponse); // free the string's allocated memory for reuse
  }
} 


int checkMetronome(int timeout) {
  int returnVal=NULL;
  // configure addresses to read metronome
  sendCommand("ID", 0x3333);
  sendCommand("MY", 0x64);
  sendCommand("DL", 0x65);

  if (Serial.available() > 0) {
    char* incomingResponse;
    incomingResponse = getData(incomingResponse, 1000);
    if (incomingResponse != NULL) { // if we didn't read a bad packet
      char* idleTimeBegin = strstr(incomingResponse,"idle:"); // check if this packet has idle time header
      if (idleTimeBegin != NULL ) { // if this packet has idle time header 
        debug.print("iOK"); // indicate the header is there
        idleTimeBegin = idleTimeBegin+6; // move to the beginning of the idle number
        char *idleTimeEnd = strstr(idleTimeBegin," "); // look for the space after the idle number
        char *idleString;
        strncpy(idleString,idleTimeBegin, idleTimeEnd - idleTimeBegin);
        free(idleTimeBegin);
        free(idleTimeEnd);
        free(idleString);
        returnVal= atoi(idleString);
      }
      else { 
        debug.print("iNo");  // indicate there was no header
      }
    }
    free(incomingResponse); // free the string's allocated memory for reuse
  }
  setupXBee(); // return to regular botanicalls configuration
}

*/

/*
int getHour(int timeout) {
    // configure addresses to read clock
  sendCommand("ID", 0xC);
  sendCommand("MY", 0x1);
  sendCommand("DL", 0x0);
  Serial.flush(); // clear the serial buffer before reading new data
  sendData("GET",0x0);
  long now = millis();
  while (millis() - now < timeout) {
  char* timeString;
  getData(timeString, 2000);
 
  boolean timeStringValid = true; // declare and initialize a variable to track whether the string has all valid characters

  for (int i=0; i < strlen(timeString); i++) {
    timeString[i] = Serial.read(); // reach each time string character into a character array
    if((timeString[i] < '0' || timeString[i] > '9') && timeString[i] !='*') {
      timeStringValid = false;  // if any character is bad then the whole string is bad
    }
  }

  if (timeStringValid == true) {
      char hourString[3];
    memset(hourString,'\0',3);
    strncpy( hourString, timeString+8, 2);
    int hour = atoi(hourString);
   return hour;
  }
  }
 return NULL; // if we didn't get a good time string return false
}
*/

///////////////////////////////// UTILITY FUNCTIONS //////////////////////////////////////////
// this function checks for a specific response on the serial port
// it accepts a string to look for and a timeout in milliseconds
boolean checkFor(char* desiredResponse, int timeout) {
  boolean result = false;
  char* incomingResponse;
    incomingResponse = getData(incomingResponse, timeout);
  if (incomingResponse != NULL) { // if we didn't read a bad packet
    if (strstr(incomingResponse,desiredResponse) != NULL ) { // if the desired string is found
      result = true;
    }
    else { 
      result = false;  // return false if the strings don't match
    }
  }
  else { 
    result = false; // return false if we got a bad packet
  }
  free(incomingResponse); // free the string's allocated memory for reuse
  return result;
}



// this function will return the number of bytes currently free in RAM
int memoryTest() {
  int byteCounter = 0; // initialize a counter
  byte *byteArray; // create a pointer to a byte array
  // More on pointers here: http://en.wikipedia.org/wiki/Pointer#C_pointers

  // use the malloc function to repeatedly attempt allocating a certain number of bytes to memory
  // More on malloc here: http://en.wikipedia.org/wiki/Malloc
  while ( (byteArray = (byte*) malloc (byteCounter * sizeof(byte))) != NULL ) {
    byteCounter++; // if allocation was successful, then up the count for the next try
    free(byteArray); // free memory after allocating it
  }
  
  free(byteArray); // also free memory after the function finishes
  return byteCounter; // send back the highest number of bytes successfully allocated
}



// this function blinks the an LED light as many times as requested
void blinkLED(byte targetPin, int numBlinks, int blinkRate) {
  for (int i=0; i<numBlinks; i++) {
    digitalWrite(targetPin, HIGH);   // sets the LED on
    delay(blinkRate);                     // waits for a blinkRate milliseconds
    digitalWrite(targetPin, LOW);    // sets the LED off
    delay(blinkRate);
  }
}

//////////// FUNCTIONS \\\\\\\\\\\\\\\\

// function that puts together a command packet
boolean sendCommand(char* command, unsigned long data) {
  static byte frameID = 0;
  frameID++; // add one to the frame ID each time, okay to overflow
  if (frameID == 0) frameID = 1; //skip zero because this disables status response packets
  byte checksum = 0xFF; // checksums are the hex FF minus the total of all bytes
  // calculate length of the packet
  int dataLength = countBytes(data);
  int length = (dataLength + 4); // data length + API id + frame id + two command bytes
  // send the packet
  Serial.print(0x7E, BYTE); // send start delimiter
  Serial.print(0x0, BYTE);  // send length MSB (always zero because packets can't be more than 100 bytes)
  Serial.print(length, BYTE); // send length LSB
  Serial.print(0x8, BYTE); // send API command identifier
  checksum = checksum - 0x8;
  Serial.print(frameID, BYTE); // send frame ID (set to 0 if no response is required)
  checksum = checksum - frameID;
  Serial.print(command);   // send two-character AT command
  for (int i=0; i < strlen(command); i++) {
    checksum = checksum - command[i]; // add in the AT command bytes
  }
  // DIVIDE DATA INTO BYTES AND ITERATE THROUGH EACH ONE
  for (int i = dataLength; i > 0; i--) {   
    byte dataByte = data >> 8 * (i-1); // shift over one byte at a time, MSB first
    Serial.print(dataByte, BYTE); // send command data
    checksum = checksum - dataByte;
  }
  Serial.print(checksum); //  send checksum
  return getCommandResults();
}


// function that receives the results of a command request
boolean getCommandResults() {  // MAYBE ADD FRAME ID AS AN ARGUMENT HERE?
  int packetLength = checkHeader(500); // check for a start byte with a 1/2 second timeout
  //  debug.print("packetLength: ");
  // debug.println(packetLength);
  if (getIdentifier(0x88)) { // if this is indeed the results of a command
    byte frameID = Serial.read(); // get the frame ID we're receiving information about
    // debug.print("frameID: ");
    // debug.println(frameID);
    // right now we're not doing anything with the frame ID, so this is a formality
    char commandReceived[3];
   // debug.print("commandReceived: ");
    for (int i=0; i < 2; i++) {
      commandReceived[i] = Serial.read(); // get the AT command we're receiving
   //   debug.print(commandReceived[i]);
      // (right now we're not doing anything with the AT command info, so this is a formality)
    }
  //  debug.println("");
    boolean status = !Serial.read(); // OK is equal to zero in the API, so invert this value when reporting it
    byte checksum = Serial.read(); // read in the checksum. We ignore this for now
    return status;
  }
  else {
    return false; // if Identifier indicates wrong packet then give negative feedback
  }
}



// function to check for the Header bit, and read in the two following length bits
int checkHeader(int timeout) { // timeout is in milliseconds
  long startTime = millis();
  int length = 0;
  int inByte = 0;
  // during the timeout period, if we haven't gotten the start byte yet...
  while (((millis() - startTime) < timeout) && (inByte != 0x7E)) {
    if (Serial.available() > 0) { // if a byte is waiting in the buffer
      inByte = Serial.read(); // read a byte from the buffer
    }
  }
  if (inByte == 0x7E) { // if we got the API start byte
    while (Serial.available() < 2); // wait for at least two bytes to be available
    int lengthMSB = Serial.read(); // read the most significant length byte
    int lengthLSB = Serial.read(); // read the least significant length byte
    length = (lengthMSB << 8) + lengthLSB; // put the two bytes together
  }
  //// The Arduino serial buffer can only hold 64 bytes, so we don't wait for more than 20
  //// to enter the buffer before moving on with the code.
  //// Wait for either timeout, full packet or at least 20 bytes...
  while (((millis() - startTime) < timeout) && Serial.available() < length+1 && Serial.available() < 20) ; // wait
  if (Serial.available() < length && Serial.available() < 20) { // test to see if we didn't meet criteria
    length = -1; // and set length negative to indicate an error
  }
  return length;
}


// function that checks to see if the API Identifier matches a requested value
boolean getIdentifier(byte idWanted) {
  long startTime = millis();
  byte apiIdentifier = 254; // set apiIdentifier to an impossible value
  while (Serial.available() < 1 && (millis() - startTime) < 500) ; // wait for a byte or timeout
  if (Serial.available() > 0) { // if a byte is waiting in the buffer
    apiIdentifier = Serial.read();
  }
  if (apiIdentifier == idWanted) {
    return true;
  }
  else {
    return false;
  }
}


// function that receives the results of a transmit request
boolean getTXstatus() {
  int packetLength = checkHeader(500); // check for a start byte with a 1/2 second timeout 
  //  debug.print("packetLength: ");
  // debug.println(packetLength);
  if (getIdentifier(0x89)) { // if this is indeed the results of a command
    byte frameID = Serial.read(); // get the frame ID we're receiving information about
    // debug.print("frameID: ");
    // debug.println(frameID,DEC);
    // right now we're not doing anything with the frame ID, so this is a formality
    boolean status = Serial.read(); // OK is equal to zero in the API, so invert this value when reporting it
    // debug.print("  status: ");
    // debug.println(status,BIN);
    byte checksum = Serial.read(); // read in the checksum. We ignore this for now
    // debug.print("  checksum: ");
    // debug.println(checksum, HEX);
    if (status == 0) {
      return true;
    }
    else {
      return false; // if Identifier indicates wrong packet then give negative feedback
    }
  }


}


// function that puts together a data packet and transmits it, using 16-bit addressing
boolean sendData(char* data, int destinationAddr) {
  static byte frameID = 0;
  frameID++; // add one to the frame ID each time, okay to overflow
  if (frameID == 0) frameID = 1; //skip zero because this disables status response packets
  byte checksum = 0xFF; // checksums are the hex FF minus the total of all bytes
  // calculate length of the packet
  int dataLength = strlen(data);
  int length = (dataLength + 5); // data length + API id + frame id + two address bytes + options byte
  // send the packet
  Serial.print(0x7E, BYTE); // send start delimiter
  Serial.print(0x0, BYTE);  // send length MSB (always zero because packets can't be more than 100 bytes)
  Serial.print(length, BYTE); // send length LSB
  Serial.print(0x1, BYTE); // send API command identifier
  checksum = checksum - 0x1;
  Serial.print(frameID, BYTE); // send frame ID (set to 0 if no response is required)
  checksum = checksum - frameID;
  for (int i = 2; i > 0; i--) {   
    byte destinationByte = destinationAddr >> 8 * (i-1); // shift over one byte at a time, MSB first
    Serial.print(destinationByte, BYTE);  // send destination address
    checksum = checksum - destinationByte;
  }

  Serial.print(0x0, BYTE); // send options: 0x0 = none, 0x1 = disable ACK, 0x4 use broadcast PAN ID
  Serial.print(data); // send all the data bytes
  for (int i=0; i < strlen(data); i++) {
    checksum = checksum - data[i]; // add in the AT command bytes
  }
  Serial.print(checksum); //  send checksum
  return getTXstatus();
}


// function that receives data which was sent using 16-bit addressing
char* getData(char* dataIn, int timeout) {
  int packetLength = checkHeader(timeout); // check for a start byte with a timeout
  debug.print("pktLen: ");
  debug.println(packetLength,DEC);
  if (packetLength > 0 && getIdentifier(0x81)) { // if we didn't get an error from check header and this is indeed a data rx packet
    if((dataIn = (char*) malloc(packetLength - 5+1)) == NULL) { // attempt to allocate string memory
      debug.println("malNO"); // report if allocation fails
    }
    else {
      debug.println("malOK"); // otherwise report that allocation succeeded
    }
    memset(dataIn,0,packetLength); // initialize all incomingResponse string positions to null

    byte addrMSB = Serial.read(); // get the MSB of the source address
    byte addrLSB = Serial.read(); // get the LSB of the source address
    // debug.print("MSB: ");
    // debug.println(MSB);
    // debug.print("LSB: ");
    // debug.println(LSB);
    lastSender = (addrMSB << 8 ) + (addrLSB); // update global variable with this sender's address
    byte RSSI = Serial.read(); // get the Received Signal Strength Indicator value
    // debug.print("RSSI: ");
    // debug.println(RSSI);
    byte options = Serial.read(); // get the options. 0 = reserved, 1 = Addr broadcast, 2 = PAN broadcast, 3 -7 = reserved
    // debug.print("options: ");
    // debug.println(options);
    long startTime = millis();
    for (int i=0; i < (packetLength - 5); i++) {
      while (((millis() - startTime) < timeout) && Serial.available() < 1) ; // wait for data
      if (Serial.available() > 0) { // if a byte is waiting in the buffer
        dataIn[i] = Serial.read(); // get a byte of data
        debug.print(dataIn[i]);
      }
    }
    debug.println("");
    byte checksum = Serial.read();
    // debug.print("checksum: ");
    // debug.println(checksum);
    return(dataIn); 
  }
  else {
    return NULL; // if this packet is bad then give negative feedback
  }
}




// puts the XBee in API mode
void setAPIMode() {
  delay(14); // 14 ms delay allows XBee to wake up from sleep mode
  boolean success = false;
  while(success == false) {
    blinkLED(ledPin, 5, 50); // strobe led
    delay(1100);
    // put the XBee in command mode
    Serial.print("+++");
    delay(1100);
    // wait for a response from the XBee for 2000 ms, or start over if no valid response comes
    blinkLED(ledPin, 5, 50); // strobe led
    // select API Mode
    Serial.println("ATRE,AP1"); // reset to factory defaults and set API mode
    // exit command mode (note that we use Serial.printLN here to issue a linefeed that completes the command sequence)
    Serial.flush(); // remove any prior "OK" responses from the serial buffer
    Serial.println("ATCN");
    long startTime = millis();
    while (((millis() - startTime) < 500) && Serial.available() < 2) ; //wait for two characters to come in
    if (Serial.read() == 'O') { // test for the first letter of "OK"
      success = true;
      Serial.flush();
    }
  }
}



// this function counts the number of bytes in a long
int countBytes (long myLong) {  
  int length=0;
  do {  
    myLong = myLong >> 8; // shift one byte over 
    length++;             // and add this byte to the count
  } while (myLong != 0); // as long as there's still a non-zero number remaining
  return length;
}
