// This program helps a plant to make a phone call.
// Rob Faludi with additional code from various public examples
// http://www.botanicalls.com
// A project with Kati London, Rob Faludi, Kate Hartman and Rebecca Bray

char version[] = "1.84";

boolean demoMode = false; // set this to true for short timeouts and no data uploads
boolean sociable = false; // set this to true to use the Sociable Objects code
byte XPortAddr = 0x64;
int site = 1; // indicator for where the plant is located
// 1 is demo, 2 is ITP lounge, 3 is Machine Project, 4 is development

// char* functions need to be declared at the start of C programs
char* getData(char* dataIn, int timeout);

byte plantID; // unique plant identifier
// time intervals for regular use
// THESE WILL BE MODIFIED IN THE SETUP FUNCTION IF DEMO MODE IS ON
int wateredTimeInterval = 30; // watering event interval in seconds
unsigned int lightTimeInterval = 18*60*60;//light intervals in seconds (for hours use h*60*60)
unsigned int moistTimeInterval = 18*60*60;//moisture interval in seconds
int dataInterval = 1800; // data sending for SQL, interval in seconds


// the positive increase in moisture that defines a watering event
int wateringCriteria = 100;

int lightNumSamples = 10; //number of sampled light values at the determined intervals
int moistNumSamples = 10; //number of sampled moisture values at the determined intervals
//most desirable state of wetness during a watering event--PLANT SPECIFIC VALUE
int desiredSoakLevel[14] = {
  600, 455, 280, 660, 700, 700, 700, 720, 700, 460, 690, 600, 550, 700};
//sufficiently dried out to be watered---PLANT SPECIFIC VALUE
int minMoist[14] = {
  450, 350, 1, 550, 400, 590, 500, 610, 500, 300, 560, 560, 330, 550};
//Unhealthfully dried out, desperately needs water---PLANT SPECIFIC VALUE
int maxDry[14] = {
  400, 280, 0, 490, 320, 500, 400, 510, 400, 200, 490, 490, 200, 490}; 
int lightMinimum = 96;// generally desired light level. Plant specific light threshholds TBD

//set up the moist array of n values---replace 10 w/96
int moistValues[10];

int moistArraySize = moistNumSamples; //size of the soil moisture array

int lightArraySize = lightNumSamples; // size of the light array 
int lightValues[10]; // set up the light array of n values--replace 10 w/96


// pins for PCB layout
byte ledPin = 13; // generic status LED
byte moistLED = 9;  // LED which indicates the plant needs water
byte sleepPin = 4; // bring this pin HIGH to make the XBee sleep and LOW to wake it up (connects to pin 9 on XBee)
byte ID1 = 5, ID2 = 6, ID3 = 7, ID4 = 8;
byte moistPin = 0; // moisture input is on analog pin 0
byte lightPin = 1; //photocell input is on analog port 1
byte batteryPin = 12; // monitor battery level. active is high


// limits the maximum number and frequency of calls
int callSpacing = 20; // minimum seconds between each call
long lastCallTime = 0; // holds the last time we made a call
int callLimit = 30000; // maximum number of attempted http connects to call
int calls = 0;  // holds the current number of attempted http connects 
int lastWatered = 255; // this holds the last value of watering event check, set high to ensure descent
int lastMoist = 255;//this holds the last value of the moisture check, set high to ensure descent
int lastLight = 255;//this holds the last value of the light check, set high to ensure descent

// sociable objects section
boolean neglected = false; // true if others had light when you didn't
int lastSender = 0; // global variable for the address of the most recent XBee sender


////// DEBUG OUTPUT IS HANDY ///////
#include <SoftwareSerial.h>
int debugRX=2, debugTX=3; // pins 2 and 3 are for debug output
SoftwareSerial debug(debugRX, debugTX); // creates SoftwareSerial on pins 6 and 7
///////////////////////////////////////////////////////////////


void setup () {
  //// for(int i = 0; i < lightArraySize; i++) {
  ////    lightValues[i] = 1023; 
  ////  }
  plantID = (digitalRead(ID1)) + (digitalRead(ID2) << 1)  + (digitalRead(ID3) << 2)  + (digitalRead(ID4) << 3); 
  for(int i = 0; i < moistArraySize; i++) {
    moistValues[i] = 0; 
  }
  // start up the serial connection with 9600-8-n-1-true (non-inverted):
  Serial.begin(9600);
  debug.begin(9600); // start software serial process
  pinMode(ledPin,OUTPUT);
  pinMode(moistLED,OUTPUT);  
  pinMode(sleepPin,OUTPUT);
  pinMode(ID1,INPUT);
  pinMode(ID2,INPUT);
  pinMode(ID3,INPUT);
  pinMode(ID4,INPUT);
  pinMode(debugRX,INPUT);
  pinMode(debugTX,OUTPUT);
  pinMode(batteryPin,INPUT);
  /////debugging serial output///////
  debug.print("start v");
  debug.print(version);
  debug.print(" ID ");
  debug.println(plantID,DEC);


  // time intervals for demo mode
  if (demoMode == true) {
    wateredTimeInterval = 5; // watering event interval in seconds
    lightTimeInterval = 5;//light intervals in seconds
    moistTimeInterval = 5;//moisture interval in seconds
    dataInterval = 36000; // data sending for SQL, interval in seconds
    int callSpacing = 5; // minimum seconds between each call
    debug.println("Demo");
  }
  lastCallTime = 5000 - ((callSpacing + 1) * 1000); // special calculation to immediately enable calls

  //////////////////////////////////
  digitalWrite(sleepPin, LOW);
  delay(14); // 14 ms delay allows XBee to wake up from sleep mode
  setAPIMode(); // puts the XBee into API packetized mode
  setupXBee(); // initialize the proper settings on the XBee radio module
  digitalWrite(sleepPin, HIGH);
  debug.print(memoryTest());
  debug.println("b free");
}


void loop () {
  if (demoMode == false) {
    // dataSend(); // send moisture data to mySQL database
  }

  byte watered = wateringEventCheck(); // returns a value dependent upon watering events
  byte moist = moistureCheck(); // returns a value dependent upon moisture level
  byte light = lightCheck(lightMinimum); // returns a value dependent upon light level
  if (millis() - lastCallTime > (callSpacing+1) * 1000 && calls < callLimit) {
    //if we're not too close to the last call and we haven't made too many calls...j
    if (watered > lastWatered) { //if there's been a positive change
      byte ctr = 0;
      debug.println("WCall");
      // place a call request, using the value returned by watering event check
      while (httpRequest("128.122.151.44","80",watered) == false && ctr < 3) {
        ctr++;
      }
      lastWatered = watered;//log the current moisture value so you can compare it to the next value that comes in

      calls++;//add one to the count of the number of phone call attempts made
      lastCallTime = millis();
    }


    else if (moist > lastMoist) { //if there's been a positive change
      byte ctr = 0;
      debug.println("MCall");
      while (httpRequest("128.122.151.44","80",moist) == false && ctr < 3) {
        ctr++;
      }
      lastMoist = moist;//log the current moisture value so you can compare it to the next value that comes in
      calls++;//add one to the count of the number of phone calls made
      lastCallTime = millis();
    }


    else  if (light != lastLight){//if there has been a change
      byte ctr = 0;
      debug.println("LCall");

      if (sociable == true && light < lastLight) { // if the sociable objects mode is enabled and light is lacking
 /*
        neglected = checkSunny();    
        if (neglected == true) {
          int hour = getHour(2000);
          if (hour == NULL || (hour > 8 && hour < 23)) { // if daytime or no response, okay to make call
            int idleTime = checkMetronome(2000);
            if (idleTime == NULL || (idleTime > 1800)) {
              while (httpRequest("128.122.151.44","80",light) == false && ctr < 3) {
                ctr++; 
              }
            }
          }
        }
      */
      }
      else if (sociable == false || neglected == true) { // if the sociable objects mode is disabled or if complaint was made
        while (httpRequest("128.122.151.44","80",light) == false && ctr < 3) {
          ctr++;
        }
      }
      lastLight = light;
      calls++;//add one to the count of the number of phone calls made
      lastCallTime = millis();
    }

  }


  lastWatered = watered;//log the current watering value so you can compare it to the next value that comes in
  lastMoist = moist;//log the current moisture value so you can compare it to the next value that comes in
  lastLight = light;//log the light value so you can compare it to the next value that comes in


  switch (moist) {
  case 2: // min moist
    blinkLED(moistLED, 1, 200);
    break;
  case 6: // max dry
    blinkLED(moistLED, 1, 50);
    break;
  default:
    int brightness = analogRead(moistPin);
    analogWrite(moistLED,brightness); // otherwise display a steady LED with brightness mapped to moisture
    break;
  }
/*
  if (sociable == true) { // if the sociable objects mode is enabled
    digitalWrite(sleepPin, LOW);
    respondToRequests();
  }
  */
}



